package org.papervision3d.materials.special 
{
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.math.Matrix3D;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.core.render.data.RenderSessionData;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.special.VectorShape3D;
	import org.papervision3d.objects.special.commands.CurveTo;
	import org.papervision3d.objects.special.commands.LineTo;
	import org.papervision3d.objects.special.commands.MoveTo;
	
	import flash.display.Graphics;	

	/**
	 * @author Mark Barcinski
	 */
	public class Letter3DMaterial extends VectorShapeMaterial {
		public var scaleStroke:Boolean = true;

		private static var viewVector:Number3D = new Number3D();
		private static var normalVector:Number3D = new Number3D();
		
		public function Letter3DMaterial(fillColor:uint = 0xFF00FF , fillAlpha : Number = 1) 
		{
			this.fillColor = fillColor;
			this.fillAlpha = fillAlpha;
		}

		override public function drawShape(vectorShape : VectorShape3D, graphics : Graphics, renderSessionData : RenderSessionData) : void {

			if(oneSide)
			{
				var camera:DisplayObject3D = renderSessionData.camera;
				var world:Matrix3D = vectorShape.world;

				viewVector.x = camera.x - world.n14;
				viewVector.y = camera.y - world.n24;
				viewVector.z = camera.z - world.n34;
				viewVector.normalize();

				normalVector.x = world.n13;
				normalVector.y = world.n23;
				normalVector.z = world.n33;

				var dot:Number = Number3D.dot( normalVector, viewVector );

				if( dot > 0 ) return;
			}

			if(fillAlpha > 0)graphics.beginFill(fillColor, fillAlpha);
			
			if(lineAlpha == 0 || lineThickness == 0 || scaleStroke == true)
				graphics.lineStyle();
			else
				graphics.lineStyle(lineThickness, lineColor, lineAlpha);
	
//			for (var i:int=0; i<vectorShape.graphicsCommands.length; i++) {
//				IVectorShape(vectorShape.graphicsCommands[i]).draw(graphics);	
//			}
//			
//			graphics.endFill();

			super.drawShape(vectorShape, graphics, renderSessionData);
			
			if(lineAlpha == 0 || lineThickness == 0 || scaleStroke == false)return;
			var prevVertex : Vertex3D;
			for ( var i:int =0; i<vectorShape.graphicsCommands.length; i++) {
//				IVectorShape(vectorShape.graphicsCommands[i]).draw(graphics);

				if(vectorShape.graphicsCommands[i] is MoveTo )
					prevVertex = MoveTo(vectorShape.graphicsCommands[i]).vertex;
					
				if(vectorShape.graphicsCommands[i] is LineTo ){
					LineTo(vectorShape.graphicsCommands[i]).drawScaledStroke( prevVertex , graphics, renderSessionData , this);
					prevVertex = LineTo(vectorShape.graphicsCommands[i]).vertex;
				}
				
				if(vectorShape.graphicsCommands[i] is CurveTo ) {
					CurveTo(vectorShape.graphicsCommands[i]).drawScaledStroke( prevVertex , graphics, renderSessionData , this);
					prevVertex = CurveTo(vectorShape.graphicsCommands[i]).anchor;
				}
			}
		}
	}
}
